using System;
using System.Windows.Forms;
using System.Drawing;

namespace DrawTools
{
	/// <summary>
	/// Ellipse graphic object
	/// </summary>
	public class DrawEllipse : DrawTools.DrawRectangle
	{
		public DrawEllipse()
		{
            SetRectangle(0, 0, 1, 1);
            Initialize();
		}

        public DrawEllipse(int x, int y, int width, int height)
        {
            Rect = new Rectangle(x, y, width, height);
            Initialize();
        }

        public override void Draw(Graphics g)
        {
            Pen pen = new Pen(Color, PenWidth);
            if ((Control.ModifierKeys & Keys.Shift) != 0)
            {
                int x = Rect.X;
                int y = Rect.Y;
                int width = Rect.Width;
                int height = Rect.Height;
                width = height;
                Rectangle rect = new Rectangle(x, y, width, height);
                Rect = rect;
            }
            g.DrawEllipse(pen, DrawRectangle.GetNormalizedRectangle(Rect));

            pen.Dispose();
        }


	}
}
